#include "MTPSpcViewer.h"
#include "MTFileList.h"
#include "MTUtilities.h"
#include "MTExceptions.h"

MTInfoWindowDataTemplate	MTPSpcViewer::kPSpcTemplate =
{
	3,
	{
		{	"ID" },
		{	"Version" },
		{	"TXMP ID" }
	}
};

struct MTPSpcFormat
{
	UInt32		id;
	UInt32		version;
	MTPSpcEntry	entries[18];
	UInt32		txmpID;
};

void MTPSpcViewer::ParseData(UInt8 * buf, UInt32 bufSize)
{
	MTPSpcFormat	* format;
	char			text[256];
	
	if(bufSize < sizeof(MTPSpcFormat))
		throw MTUnsupportedException("Unsupported data structure");
	
	format = (MTPSpcFormat *)buf;
	
	SWAP32(format->id);
	SWAP32(format->version);
	SWAP32(format->txmpID);
	
	for(UInt32 i = 0; i < 18; i++)
	{
		SWAP16(format->entries[i].x);
		SWAP16(format->entries[i].y);
	}
	
	id =		format->id;
	version =	format->version;
	txmpID =	format->txmpID;
	
	entries.clear();
	for(UInt32 i = 0; i < 9; i++)
	{
		if(	format->entries[i + 0].x ||
			format->entries[i + 0].y ||
			format->entries[i + 9].x ||
			format->entries[i + 9].y)
		{
			MTPSpcParsedEntry	entry;
			
			entry.l = format->entries[i + 0].x;
			entry.t = format->entries[i + 0].y;
			entry.r = format->entries[i + 9].x;
			entry.b = format->entries[i + 9].y;
			
			entries.push_back(entry);
		}
	}
	
	AttachDataTemplate(&kPSpcTemplate);
	
	SetNumEntries(3 + entries.size());
	
	std::sprintf(text, "%.8X", id);
	SetEntryData(0, text, 0);
	
	std::sprintf(text, "%.8X", version);
	SetEntryData(1, text, 0);
	
	std::sprintf(text, "%.8X", txmpID);
	SetEntryData(2, text, 0);
	
	for(UInt32 i = 0; i < entries.size(); i++)
	{
		std::sprintf(text, "{%d, %d}-{%d, %d}", entries[i].l, entries[i].t, entries[i].r, entries[i].b);
		SetEntryTitle(3 + i, "Rectangle", 0);
		SetEntryData(3 + i, text, 0);
	}
	
	SetOwnerName("PSpc");
	
	DisposePtr((Ptr)buf);
}